<?php
/**
 * @package CreatorPilot
 * @version 0.0.3
 */
/*
Plugin Name: Creator Pilot
Plugin URI: http://wordpress.org/plugins/creator-pilot/
Description: one to three testing
Author: creatorpilot.ai
Version: 0.0.3
Author URI: https://creatorpilot.ai/
*/

define( 'PLUGIN_DIR', dirname(__FILE__).'/' );
include "classes/variables.php";
include "classes/utils.php";
include "classes/menu.php";
include "classes/pages.php";

global $api_url;
global $session_cookie;
// check if we URL are local or not
if( strpos( $_SERVER['HTTP_HOST'], 'createpilot.local' ) !== false ){
    $api_url = 'http://localhost:3000/v1';
} else {
    $api_url = 'https://stage.api.creatorpilot.ai/v1';
}

/**
 * Receive Heartbeat data and respond.
 *
 * Processes data received via a Heartbeat request, and returns additional data to pass back to the front end.
 *
 * @param array $response Heartbeat response data to pass back to front end.
 * @param array $data     Data received from the front end (unslashed).
 *
 * @return array
 */
function receive_heartbeat( array $response, array $data ) {
	// If we didn't receive our data, don't send any back.
	if ( empty( $data['status'] ) ) {
		return $response;
	}

    $session_cookie = unserialize( get_option( 'Creator_Pilot_Session' ) );

    // check backend if the company is ready
    global $api_url;
    $api_url = $api_url . '/company/status';
    
    $responseFromServer = wp_remote_get( $api_url, array(
        'cookies' => $session_cookie
    ) );

    if( is_wp_error( $responseFromServer ) ){
        $error_message = $responseFromServer->get_error_message();
        $response['status'] = $error_message;
    } else {
        $api_data = json_decode( wp_remote_retrieve_body( $responseFromServer ), true );
        $response['api_data'] = $api_data;
        if( $api_data['status'] === 'ready' ){
            $response['status'] = 'ready';
        } else {
            $response['status'] = 'not ready';
        }
    }
	
	return $response;
}
add_filter( 'heartbeat_received', 'receive_heartbeat', 10, 2 );

function plugin_activate() {

    // Set $default_value
    $default_text = 'This field is empty';
    // Get various values form the wp_options table
    $email = get_option( 'admin_email', $default_text );
    $site = get_option( 'siteurl', $default_text );

    // delete the Creator_Pilot_Company and Creator_Pilot_Session WP option if it exists - we will get a fresh one
    delete_option('Creator_Pilot_Session');

    // create creatorpilot tag if not exists
    if ( !term_exists( 'creatorpilot', 'post_tag' ) ) {
        wp_insert_term( 'creatorpilot', 'post_tag' );
    }

    // check if local or not
    if( strpos( $_SERVER['HTTP_HOST'], 'createpilot.local' ) !== false ){
        $site = 'https://isphere.dk';
    } else {
        $site = get_option( 'siteurl', $default_text );
    }

    global $api_url;
    $api_url = $api_url . '/company';
    
    // Make the API call
    $response = wp_remote_post( $api_url, array(
        'method' => 'POST',
        'body' => array(
            'email' => $email,
            'website' => $site
        )
    ) );

    if ( is_wp_error( $response ) ) {
        
        // Handle API errors
        $error_message = $response->get_error_message();
        update_option( 'Creator_Pilot_Status', $api_url . 'error: '  .  $error_message );
        

    } else {
        
        $api_data = json_decode( wp_remote_retrieve_body( $response ), true ); 
        // get id value from the api_data and save it to the Creator_Pilot_License option if it is not already set and not empty
        if( !get_option( 'Creator_Pilot_License' ) && !empty( $api_data['license'] ) ){
            add_option( 'Creator_Pilot_License', $api_data['license'] );
        }


        // Retrieve cookies from the response
        $cookies = wp_remote_retrieve_cookies( $response );

        // save cookies for this session if they exist
        if( $cookies ){
            add_option( 'Creator_Pilot_Session', serialize( $cookies ) );
        }


    }
    

    /* activation code here */
}
register_activation_hook( __FILE__, 'plugin_activate' );


// Enqueue JavaScript for handling the form submission and API call
add_action( 'admin_enqueue_scripts', 'enqueue_input_scripts' );
function enqueue_input_scripts() {

    wp_enqueue_script(
		'ajax-script',
		plugins_url( '/scripts/input-script.js', __FILE__ ),
		array( 'jquery' ),
		'1.0.0',
		array(
		   'in_footer' => true,
		)
	);

    wp_localize_script( 'ajax-script', 'my_ajax_obj', 
    array(
        'ajax_url' => admin_url( 'admin-ajax.php' )
    ));
    
}

function enqueue_admin_custom_css(){

    $current_page = '';
    if( isset( $_GET['page'] ) ){
        $current_page = $_GET['page'];
    }
    // initialize array of strings with the following values creatorpilot-data || creatorpilot-strategy || creatorpilot-keywords || creatorpilot-status
    $pages = array('creatorpilot-dashboard', 'creatorpilot-data', 'creatorpilot-strategy', 'creatorpilot-status', 'creatorpilot-keywords');
    
    // check if the current page is in the array
    if ( in_array($current_page, $pages) ) {
        wp_enqueue_style( 'bootstrap', plugins_url( '/styles/bootstrap.min.css', __FILE__ ));
        wp_enqueue_style( 'creatorpilot', plugins_url( '/styles/creatorpilot.css', __FILE__ ));
    }

}
add_action( 'admin_enqueue_scripts', 'enqueue_admin_custom_css' );

wp_enqueue_script(
    'bootstrap-script',
    plugins_url( '/scripts/bootstrap.bundle.min.js', __FILE__ ),
    array( 'jquery' ),
    '5.3.3',
    array(
       'in_footer' => true,
    )
);


// audience, customer and keyword actions

// default handler if the user is not logged in
function logged_out_handler() {
    ?>
    echo 'You must be logged in';
    <?php
}

add_action( 'wp_ajax_audience_submit', 'audience_handler' );
add_action( 'wp_ajax_nopriv_audience_submit', 'logged_out_handler' ); // For logged-out users if needed
// Handle the AJAX request
function audience_handler() {

    // Set $default_value
    $default_text = 'This field is empty';

    global $api_url;
    // Make the API call
    $response = wp_remote_post( $api_url . '/audience/' . $_POST['audienceId'], array(
        'method' => 'PATCH',
        'body' => array(
            'audience' => $_POST['audience'],
            'audienceIntent' => $_POST['audienceIntent'],
            'toHelpMeWith' => $_POST['toHelpMeWith'],
            'andHelpMeWith' => $_POST['andHelpMeWith']
        )
    ) );

    $api_data = json_decode( wp_remote_retrieve_body( $response ), true ); 

    // Handle the API response and create posts
    if ( is_wp_error( $response ) ) {
        
        // Handle API errors
        $error_message = $response->get_error_message();
        
        wp_send_json_error( $error_message . $api_data );

    } else {

        $return = array(
            'redirect' => get_admin_url() . 'admin.php?page=creatorpilot-data',
            'message'  => 'Success! Redirecting to the next step...',
            'response' => $api_data
        );
        wp_send_json_success( $return );
    }

    wp_die(); // Always end AJAX requests with wp_die()
}

add_action( 'wp_ajax_customer_submit', 'customer_handler' );
add_action( 'wp_ajax_nopriv_customer_submit', 'logged_out_handler' ); // For logged-out users if needed
// Handle the AJAX request
function customer_handler() {

    // Get the input values
    $input_value1 = sanitize_text_field( $_POST['input1'] );
    $input_value2 = sanitize_text_field( $_POST['input2'] );
    $input_value3 = sanitize_text_field( $_POST['input3'] );
    $input_value4 = sanitize_text_field( $_POST['input4'] );

    global $api_url;
    
    // Make the API call
    $response = wp_remote_post( $api_url + '/customer/', array(
        'method' => 'POST',
        'body' => array(
            'target' => $input_value1,
            'lookingFor' => $input_value2,
            'toHelpThem' => $input_value3,
            'and' => $input_value4,
            'email' => $email
        )
    ) );

    // Handle the API response and create posts
    if ( is_wp_error( $response ) ) {
        
        // Handle API errors
        $error_message = $response->get_error_message();
        wp_send_json_error( $error_message );

    } else {
        
        /* Process the API data */
        $api_data = json_decode( wp_remote_retrieve_body( $response ), true ); 
        
        $return = array(
            'redirect' => get_admin_url() . '/admin.php?page=creatorpilot-strategy',
            'message'  => 'Success! Redirecting to the next step...'
        );
        wp_send_json_success( $return );
    }

    wp_die(); // Always end AJAX requests with wp_die()
}


add_action( 'wp_ajax_keyword_submit', 'keyword_handler' );
add_action( 'wp_ajax_nopriv_keyword_submit', 'logged_out_handler' ); // For logged-out users if needed
// Handle the AJAX request
function keyword_handler() {

    // Get the input values
    $input_value1 = sanitize_text_field( $_POST['input1'] );
    $input_value2 = sanitize_text_field( $_POST['input2'] );
    $input_value3 = sanitize_text_field( $_POST['input3'] );
    $input_value4 = sanitize_text_field( $_POST['input4'] );

    global $api_url;
    // Make the API call
    $response = wp_remote_post( $api_url + '/keywords/', array(
        'method' => 'POST',
        'body' => array(
            'target' => $input_value1,
            'lookingFor' => $input_value2,
            'toHelpThem' => $input_value3,
            'and' => $input_value4
        )
    ) );

    // Handle the API response and create posts
    if ( is_wp_error( $response ) ) {
        
        // Handle API errors
        $error_message = $response->get_error_message();
        wp_send_json_error( $error_message );

    } else {

        /* Process the API data */
        $api_data = json_decode( wp_remote_retrieve_body( $response ), true ); 
        
        /* Process the API data and create posts
        foreach ( $api_data as $item ) {
            $post_data = array(
                'post_title'    => $item['title'], 
                'post_content'  => $item['content'],
                'post_status'   => 'publish', 
                'post_type'     => 'post'
            );
            wp_insert_post( $post_data );
        }
        */

        $return = array(
            'redirect' => get_admin_url() . '/admin.php?page=creatorpilot-status',
            'message'  => 'Success! Redirecting to the next step...'
        );
        wp_send_json_success( $return );
    }

    wp_die(); // Always end AJAX requests with wp_die()
}