<?php

/** PAGE functions */

function creatorpilot_dashboard_page() {

    // Add your dashboard content here
    global $api_url;
    
    // get session cookie
    $session_cookie = unserialize( get_option( 'Creator_Pilot_Session' ) );
    
    // make get request to api/audience and handle session cookies
    $response = wp_remote_get( $api_url . '/audience', array(
        'cookies' => $session_cookie
    ) );

    $data = json_decode( wp_remote_retrieve_body( $response ), true );

	?>

    <div class="container-fluid my-5 mx-4">
	
        <nav class="nav nav-pills flex-column flex-sm-row" style="min-width 30rem; max-width: 60rem;">
            <a class="flex-sm-fill text-sm-center nav-link <?php echo $_GET['page'] == 'creatorpilot-dashboard' ? 'active' : ''; ?>" href="<?php echo get_admin_url() . 'admin.php?page=creatorpilot-dashboard'; ?>">Step 1</a>
            <a class="flex-sm-fill text-sm-center nav-link <?php echo $_GET['page'] == 'creatorpilot-data' ? 'active' : ''; ?>" href="<?php echo get_admin_url() . 'admin.php?page=creatorpilot-data'; ?>">Step 2</a>
            <a class="flex-sm-fill text-sm-center nav-link <?php echo $_GET['page'] == 'creatorpilot-status' ? 'active' : ''; ?>" href="<?php echo get_admin_url() . 'admin.php?page=creatorpilot-status'; ?>">Step 3</a>
        </nav>

	    <form id="audience_submit" method="post" class="action-form needs-validation" novalidate>
        
            <input type="hidden" name="action" value="audience_submit">
            <input type="hidden" name="audienceId" value="<?php echo $data['id']; ?>">

            <div class="card bg-white border-0 p-4 w-100" style="min-width 30rem; max-width: 60rem;">

                <div class="card-body">

                    <?php if ( $data['audienceIntent'] ): ?>
                    <h1 class="fs-5 fw-bold">Welcome to CreatorPilot!</h1>
                    <p class="fs-6 mt-4">
                        We automatically gathered the following data about your site. If you want to change any of it, you can do so below.
                        Otherwise you can continue to the next step.
                    </p>
                    <?php else: ?>
                    <h1 class="fs-5 fw-bold">We were NOT able to gather enough data about your site.</h1>

                    <p class="fs-6 mt-4">
                        Do not worry though, we did find some interesting things, we just need your help to help us clarify!
                        Please take a minute to fill in those 4+ simple fields.
                    </p>
                    <?php endif; ?>
                    <div class="initial-info-fields p-4">
                        <section class="mb-4 d-flex flex-column flex-sm-row align-items-center">
                            <label for="audience" class="form-label ">My target audience consists primarily of</label>
                            <input type="text" class="form-control mx-0 mx-md-3" id="audience" name="audience" aria-describedby="audienceHelpBlock" placeholder="travel enthusiasts" value="<?php echo $data['audience']; ?>" required>
                            <!--
                            <div id="audienceHelpBlock" class="form-text">
                                e.g. contain letters and numbers, and must not contain spaces, special characters, or emoji.
                            </div>
                            -->
                        </section>

                        <section class="mb-4 d-flex flex-column flex-sm-row align-items-center">
                            <label for="audienceIntent" class="form-label">looking for</label>
                            <input type="text" class="form-control mx-0 mx-md-3" id="audienceIntent" name="audienceIntent" aria-describedby="audienceIntentHelpBlock" placeholder="a community travel website" value="<?php echo $data['audienceIntent']; ?>" required>
                            <!--
                            <div id="audienceIntentHelpBlock" class="form-text">
                            e.g. 8-20 characters long, contain letters and numbers.
                            </div>
                            -->
                            <label for="toHelpMeWith" class="form-label">to help them</label>
                            <input type="text" class="form-control mx-0 mx-md-3" name="toHelpMeWith" id="toHelpMeWith" aria-describedby="toHelpThemHelpBlock" placeholder="discover great places" value="<?php echo $data['toHelpMeWith']; ?>" required>
                            <!--
                            <div id="toHelpThemHelpBlock" class="form-text">
                            e.g. Your password must be 8-20 characters long, contain letters and numbers.
                            </div>
                            -->
                        </section>

                        <section class="mb-4 d-flex flex-column flex-sm-row align-items-center">

                            <label for="andHelpMeWith" class="form-label">and</label>
                            <input type="text" class="form-control mx-0 mx-md-3" name="andHelpMeWith" id="andHelpMeWith" aria-describedby="andHelpBlock" placeholder="plan their next vacation" value="<?php echo $data['andHelpMeWith']; ?>" required>
                            <!--
                            <div id="andHelpBlock" class="form-text">
                            e.g. Contain letters and numbers, and must not contain spaces, special characters, or emoji.
                            </div>
                            -->
                            <!--
                            <div class="mt-4">
                                <button class="btn btn-secondary" disabled type="submit">Add an 'and'</button>
                            </div>
                            -->
                        </section>
                    </div>
                    <section class="collapse mt-5" id="jobs-to-be-done">

                        <h4>Customer profile</h4>
                        <small>Audience - ICP Framework</small>

                        <div class="d-flex flex-column flex-sm-row justify-content-between mt-4">

                            <div>
                                <h6>Demographics<span class="dashicons dashicons-editor-help"></span></h6>
                                <label for="spend">Spend</label>
                                <textarea name="spend" class="form-control"><?php echo $data['spend']; ?></textarea>

                                <label class="form-label mt-2" for="engagement">Engagement</label>
                                <textarea name="engagement" class="form-control"><?php echo $data['engagement']; ?></textarea>
                            </div>
                            <div>
                                <h6>Psychology<span class="dashicons dashicons-editor-help"></span></h6>

                                <label class="form-label" for="age">Age</label>
                                <textarea name="age" class="form-control"><?php echo $data['age']; ?></textarea>

                                <label class="form-label mt-2" for="geography">Geography</label>
                                <textarea name="geography" class="form-control"><?php echo $data['geography']; ?></textarea>

                                <label class="form-label mt-2" for="occupation">Occupation</label>
                                <textarea name="occupation" class="form-control"><?php echo $data['occupation']; ?></textarea>

                                <label class="form-label mt-2" for="incomeLevel">Income level</label>
                                <textarea name="incomeLevel" class="form-control"><?php echo $data['income']; ?></textarea>
                            </div>
                            <div>
                                <h6>Behavioral traits <span class="dashicons dashicons-editor-help"></span></h6>

                                <label class="form-label" for="values">Values</label>
                                <textarea name="values" class="form-control"><?php echo $data['values']; ?></textarea>

                                <label class="form-label mt-2" for="interests">Interests</label>
                                <textarea name="interests" class="form-control"><?php echo $data['interests']; ?></textarea>

                                <label class="form-label mt-2" for="lifestyle">Lifestyle</label>
                                <textarea name="lifestyle" class="form-control"><?php echo $data['lifestyle']; ?></textarea>
                            </div>
                        </div>
                        <div>
                            <h4 class="mt-5">Jobs To be Done - JTBD Framework<span class="dashicons dashicons-editor-help"></span></h4>

                            <div class="d-flex flex-column flex-sm-row align-items-center">
                                <label class="form-label" for="JTBD1">Job 1</label>
                                <textarea name="JTBD1" class="form-control" name="painpoint1"><?php echo $data['painPoint1']; ?></textarea>
                            </div>

                            <div class="d-flex flex-column flex-sm-row align-items-center">
                            <label class="form-label" for="JTBD2">Job 2</label>
                                <textarea name="JTBD2" class="form-control" name="Painpoint2"><?php echo $data['painPoint2']; ?></textarea>
                            </div>

                            <div class="d-flex flex-column flex-sm-row align-items-center">
                                <label class="form-label" for="JTBD3">Job 3</label>
                                <textarea name="JTBD3" class="form-control" name="Painpoint3"><?php echo $data['painPoint3']; ?></textarea>
                            </div>

                        </div>

                    </section>

                </div>
                <div class="card-footer bg-white border-0 d-flex flex-column align-items-end">

                    <a class="btn more-options-btn mb-4" data-bs-toggle="collapse" href="#jobs-to-be-done" role="button" aria-expanded="false" aria-controls="collapseExample">Show more options</a>
                    <input type="submit" name="submit" value="Continue setup" id="submit" class="btn btn-primary continue-btn"></input>

                </div>
            </div>
        </form>
    </div>

    <?php
}

function creatorpilot_data_page() {

    // Add your dashboard content here
    global $api_url;
    
    // get session cookie
    $session_cookie = unserialize( get_option( 'Creator_Pilot_Session' ) );
    
    // make get request to api/audience and handle session cookies
    $response = wp_remote_get( $api_url . '/company', array(
        'cookies' => $session_cookie
    ) );

    $data = json_decode( wp_remote_retrieve_body( $response ), true );
    //echo serialize( $data );
    
    ?>

    <div class="container-fluid my-5 mx-4">

        <nav class="nav nav-pills flex-column flex-sm-row" style="min-width 30rem; max-width: 60rem;">
            <a class="flex-sm-fill text-sm-center nav-link <?php echo $_GET['page'] == 'creatorpilot-dashboard' ? 'active' : ''; ?>" href="<?php echo get_admin_url() . 'admin.php?page=creatorpilot-dashboard'; ?>">Step 1</a>
            <a class="flex-sm-fill text-sm-center nav-link <?php echo $_GET['page'] == 'creatorpilot-data' ? 'active' : ''; ?>" href="<?php echo get_admin_url() . 'admin.php?page=creatorpilot-data'; ?>">Step 2</a>
            <a class="flex-sm-fill text-sm-center nav-link <?php echo $_GET['page'] == 'creatorpilot-status' ? 'active' : ''; ?>" href="<?php echo get_admin_url() . 'admin.php?page=creatorpilot-status'; ?>">Step 3</a>
        </nav>

        <form id="audience-form" action="" method="post" class="action-form">

            <input type="hidden" name="action" value="company_submit">

            <div class="card border-0 bg-light p-5 w-100" style="min-width 30rem; max-width: 60rem;">

                <div class="card-body">
                    <h2>Setup your CreatorPilot account</h2>
                    <p>We found your email from your Wordpress installation, please update it if you want to use a different email address.</p>
                    <p>Your license key <strong><?php echo $data['license']; ?></strong> has been sent to your <strong><?php echo $data['email']; ?></strong> - Save it in a safe place.</p>

                <label for="email" class="form-label">Email address</label>
                <div class="input-group d-flex mb-4">  
                    <input type="text" class="form-control" name="email" id="email" placeholder="Your email" value="<?php echo $data['email']; ?>">
                    <button class="btn btn-primary">Update</button>
                </div>
                
                <label for="license_key" class="form-label">License key</label>
                <div class="input-group d-flex mb-4">
                    <input type="text" class="form-control" disabled name="license_key" id="license_key" placeholder="Your license key" value="<?php echo $data['license']; ?>">
                </div>
                
            </div>
            <div class="card-footer border-0 bg-light d-flex align-items-start justify-content-end">
                <a href="<?php echo get_admin_url() . 'admin.php?page=creatorpilot-status'; ?>">
                    <input name="status" value="Continue" class="btn btn-primary"></input>
                </a>    
            </div>
        </form>
    </div>
    <?php
}

function creatorpilot_strategy_page() {

        // Add your dashboard content here
        global $api_url;
    
        // get session cookie
        $session_cookie = unserialize( get_option( 'Creator_Pilot_Session' ) );
        
        // make get request to api/audience and handle session cookies
        $response = wp_remote_get( $api_url . '/configuration', array(
            'cookies' => $session_cookie
        ) );
    
        $data = json_decode( wp_remote_retrieve_body( $response ), true );
        
    ?>

<div class="container-fluid my-5 mx-4">

    <nav class="nav nav-pills flex-column flex-sm-row" style="min-width 30rem; max-width: 60rem;">
        <a class="flex-sm-fill text-sm-center nav-link <?php echo $_GET['page'] == 'creatorpilot-dashboard' ? 'active' : ''; ?>" href="<?php echo get_admin_url() . 'admin.php?page=creatorpilot-dashboard'; ?>">Step 1</a>
        <a class="flex-sm-fill text-sm-center nav-link <?php echo $_GET['page'] == 'creatorpilot-data' ? 'active' : ''; ?>" href="<?php echo get_admin_url() . 'admin.php?page=creatorpilot-data'; ?>">Step 2</a>
        <a class="flex-sm-fill text-sm-center nav-link <?php echo $_GET['page'] == 'creatorpilot-strategy' ? 'active' : ''; ?>" href="<?php echo get_admin_url() . 'admin.php?page=creatorpilot-strategy'; ?>">Step 3</a>
        <a class="flex-sm-fill text-sm-center nav-link <?php echo $_GET['page'] == 'creatorpilot-status' ? 'active' : ''; ?>" href="<?php echo get_admin_url() . 'admin.php?page=creatorpilot-status'; ?>">Step 4</a>
    </nav>

    <form id="keyword-form" action="" method="post" class="action-form">
        <input type="hidden" name="action" value="keyword_submit">

        <h1 class="wp-heading-inline">SEO Strategy</h1>
        <p>
            This is the SEO strategy we have come up with for your site. Please review and finalize it.
        </p>

        <div class="card bg-light border-0" style="min-width 30rem; max-width: 60rem;">

                <div class="card-body d-flex flex-column flex-sm-row justify-content-between">

                    <div>

                        <h2>Master keyword</h2>
                        
                        <p class="py-2.5">
                            <label for="master-keyword-diffulty">Max keyword difficulty</label>
                            <input type="range" class="form-range" min="0" max="75" step="1" name="masterKeywordDiffulty" value="<?php echo $data['maxKeywordDifficulty']; ?>">
                        </p>
                        <p class="py-2.5">
                            <label for="master-keyword-volume">Max keyword volume</label>
                            <input type="range" class="form-range" min="0" max="75" step="1" name="masterKeywordVolume" value="<?php echo $data['maxKeywordVolume']; ?>">
                        </p>

                    </div>
                    
                    <div>

                        <h2>Cluster keyword</h2>
                            
                        <div class="form-check d-flex align-items-center mb-4">
                            <input class="form-check-input me-2" type="checkbox" value="" id="flexCheckChecked" checked>
                            <label class="form-check-label" for="flexCheckChecked">Checked checkbox</label>
                        </div>
        
                        <p class="py-2.5">
                            <label for="cluster-keyword-diffulty">Max keyword difficulty</label>
                            <input type="range" class="form-range" min="0" max="75" step="1" name="clusterKeywordDiffulty" value="<?php echo $data['maxKeywordDifficulty']; ?>" >
                        </p>
                        <p class="py-2.5">
                            <label for="cluster-keyword-volume">Max keyword volume</label>
                            <input type="range" class="form-range" min="0" max="75" step="1" name="clusterKeywordVolume" value="<?php echo $data['maxKeywordVolume']; ?>"   >
                        </p>
                        <p class="py-2.5">
                            <label for="cluster-keyword-cluster">Max keywords per cluster - max 10</label>
                            <input type="range" class="form-range" min="0" max="75" step="1" name="keywordClusterLimit" value="<?php echo $data['keywordClusterLimit']; ?>">
                        </p>
                </div>
            </div>
            <div class="card-footer border-0 bg-light d-flex align-items-start justify-content-end">
                <input type="submit" name="submit" value="Continue" id="submit" class="btn btn-primary"></input>
            </div>

        </div>
    </form>

    </div>
    <?php
}

function creatorpilot_status_page() {
        // get session cookie
        $session_cookie = unserialize( get_option( 'Creator_Pilot_Session' ) );
        
        // make get request to api/audience and handle session cookies
        global $api_url;
        $response = wp_remote_post( $api_url . '/keywords/generate', array(
            'method' => 'POST',
            'cookies' => $session_cookie
        ) );

        $data = json_decode( wp_remote_retrieve_body( $response ), true );
    ?>
    
    <div class="container-fluid my-5 mx-4" id="status-page">


        <nav class="nav nav-pills flex-column flex-sm-row" style="min-width 30rem; max-width: 60rem;">
            <a class="flex-sm-fill text-sm-center nav-link <?php echo $_GET['page'] == 'creatorpilot-dashboard' ? 'active' : ''; ?>" href="<?php echo get_admin_url() . 'admin.php?page=creatorpilot-dashboard'; ?>">Step 1</a>
            <a class="flex-sm-fill text-sm-center nav-link <?php echo $_GET['page'] == 'creatorpilot-data' ? 'active' : ''; ?>" href="<?php echo get_admin_url() . 'admin.php?page=creatorpilot-data'; ?>">Step 2</a>
            <a class="flex-sm-fill text-sm-center nav-link <?php echo $_GET['page'] == 'creatorpilot-status' ? 'active' : ''; ?>" href="<?php echo get_admin_url() . 'admin.php?page=creatorpilot-status'; ?>">Step 3</a>
        </nav>




        <div class="card border-0 bg-light p-4"  style="min-width 30rem; max-width: 60rem;">
            <div class="card-body">
                <?php if ( wp_remote_retrieve_response_code( $response ) === 402 ): ?>
                    <div class="alert alert-warning" role="alert">You have reached your keyword limit. Please <a href="https://creatorpilot.io/account">upgrade</a> to continue.</div>
                <?php else: ?>
            
                <h1>You're all set!</h1>
                <p>We are currently creating your keywords and will send you a notification when they are ready.</p>

                <div class="progress" style="height: 30px;">
                    <div id="progress-bar" class="progress-bar progress-bar-animated" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100"></div>
                </div>

                
                <iframe class="mt-5" width="100%" height="315" src="https://www.youtube.com/embed/mLreMVNBSY8?si=vH-rnqH0Mswh86ZB&amp;controls=0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                <?php endif; ?>
            </div>
        </div>
        
        
        
    </div>
    <?php
}

function creatorpilot_keywords_page() {

    // get session cookie
    $session_cookie = unserialize( get_option( 'Creator_Pilot_Session' ) );

    // get the parameter update from the url
    $update = isset( $_GET['update'] ) ? $_GET['update'] : false;

    // make get request to api/audience and handle session cookies
    global $api_url;
    $response = wp_remote_get( $api_url . '/keywords', array(
        'cookies' => $session_cookie
    ) );

    // check if response is successful
    if ( wp_remote_retrieve_response_code( $response ) !== 200 ) {
        echo 'Error: ' . wp_remote_retrieve_response_code( $response );
        return;
    }
    else {
        $data = json_decode( wp_remote_retrieve_body( $response ), true );

        // check if posts external id is defined and if that ID is a post in the database
        foreach ( $data as $keyword ) {
            // if its and update a post is present and the externalId is not defined
            if ( $update && $keyword['post'] && !$keyword['post']['externalId'] ) {
                // create the post and update the keyword externalId
                
                $status = $keyword['post']['published'] ? 'publish' : 'draft';

                // Base post data array
                $post_data = array(
                    'post_title'    => wp_strip_all_tags($keyword['post']['title']),
                    'post_content'  => $keyword['post']['content'],
                    'post_status'   => $status,
                    'post_type'     => 'post',
                    'tags_input'    => array('creatorpilot')
                );

                // if the post is published, set the post date to now
                if ($status === 'publish') {
                    $post_data['post_date'] = date('Y-m-d H:i:s');
                }

                // Add Yoast metadata if available
                if (function_exists('yoast_get_meta_options')) {
                    $yoast_meta = array(
                        'yoast_wpseo_title' => $keyword['post']['title'],
                        'yoast_wpseo_metadesc' => $keyword['post']['description'],
                        'yoast_wpseo_focuskw' => $keyword['title']
                    );
                    
                    // Add Yoast meta to post data
                    $post_data['yoast_meta'] = $yoast_meta;
                }

                // If post_id is provided, update existing post
                if ($keyword['post']['externalId']) {
                    wp_update_post($post_data);
                } else {
                    // Create new post
                    $post_id = wp_insert_post($post_data);

                    // upload featured image
                    if ($keyword['post']['image']) {
                        
                        $url     = $keyword['post']['image'];
                        $post_id = $post_id;
                        $desc    = $keyword['post']['title'] . ' featured image';

                        $image_id = media_sideload_image($url, $post_id, $desc, 'id');
                        
                        if (!is_wp_error($image_id)) {
                            // Set as featured image using the attachment ID
                            set_post_thumbnail($post_id, $image_id);
                        } else {
                            error_log('Failed to upload featured image: ' . $image_id->get_error_message());
                        }
                    }
                    

                    if (!is_wp_error($post_id)) {
                        $keyword['post']['externalId'] = $post_id;
                    } else {
                        // Handle error
                        error_log('Failed to create post: ' . $post_id->get_error_message());
                        return false;
                    }

                    // call the api to update the keyword with the new post id
                    $response = wp_remote_post($api_url . '/posts/update/externalId/' . $keyword['post']['id'] . '/' . $keyword['post']['externalId'], array(
                        'method' => 'PATCH',
                        'cookies' => $session_cookie,
                        'timeout' => 30, // Add timeout to prevent hanging
                    ));

                    // Check for WordPress HTTP API errors
                    if (is_wp_error($response)) {
                        error_log('WP Remote Post Error: ' . $response->get_error_message());
                        return false;
                    }
                }

            }
        }
    }
    
    ?>
    
    <div class="container-fluid my-2 mx-2 p-4">
    
        <table class="table table-striped table-hover">
            <thead>
                <tr>
                    <th colspan="3" scope="col">
                        Your suggested keywords
                    </th>
                    <th colspan="5" class="text-end">
                
                        <button class="btn btn-info btn-sm" onclick="collectCheckedInputs(true)">Create + Publish</button>
                        <button class="btn btn-primary btn-sm" onclick="collectCheckedInputs(false)">Create + Draft</button>

                    </th>
                </tr>
                <tr>
                    <th scope="col"><input class="form-check-input" type="checkbox" onclick="selectAllKeywords(this)" id="select-all-keywords"></th>
                    <th scope="col">Article</th>
                    <th scope="col">Keyword</th>
                    <th scope="col">Cluster</th>
 
                    <th class="d-none" scope="col">KD</th>
                    <th class="d-none" scope="col">KV</th>
                    <th class="d-none" scope="col">Avg. KD</th>

                    <th scope="col">SEO Score</th>
                </tr>            
            </thead>
            <tbody>
            <?php foreach ( $data as $keyword ): ?>
                <tr>
                    <td scope="row">
                        <input class="form-check-input" type="checkbox" data-keyword-id="<?php echo $keyword['id']; ?>">
                    </td>
                    <td>
                        <!-- show post title if post is defined and link to wp post -->
                        <?php if ( $keyword['post'] ): ?>
                            <?php echo $keyword['post']['title']; ?>
                            <!-- check if externalId is defined and if it is a post in the database -->
                            <?php if ( $keyword['post']['externalId'] ): ?>
                                <p><a class="small" href="<?php echo get_edit_post_link( $keyword['post']['externalId'] ); ?>">edit</a></p>
                            <?php endif; ?>
                        <?php endif; ?>
                        
                    </td>
                    <td>
                        <?php echo $keyword['title']; ?>
                    </td>
                    <td>
                    <!-- show 3 cluster keywords -->
                    <?php if ( $keyword['clusterKeywords'] ): ?>
                        <?php foreach ( array_slice( $keyword['clusterKeywords'], 0, 3 ) as $subKeyword ): ?>
                            <span class="badge rounded-pill text-bg-light"><?php echo $subKeyword['title']; ?></span>
                        <?php endforeach; ?>
                        <?php endif; ?>
                        <a class="badge rounded-pill text-bg-light" data-bs-toggle="collapse" href="#clusterKeywords-<?php echo $keyword['id']; ?>">...</a>
                        </td>
                        <td class="d-none"><?php echo $keyword['difficulty']; ?></td>
                        <td class="d-none"><?php echo $keyword['volume']; ?></td>
                        <td class="d-none"><?php echo $keyword['avg_kd']; ?></td>
                        <td><?php echo $keyword['seo_score']; ?></td>
                    </tr>
                    <?php if ( $keyword['clusterKeywords'] ): ?>
                    <tr class="collapse" id="clusterKeywords-<?php echo $keyword['id']; ?>">
                        <td colspan="3">
                
                        </td>
                        <td colspan="5" class="text-start">
                            <?php foreach ( $keyword['clusterKeywords'] as $subKeyword ): ?>
                                <span class="badge rounded-pill text-bg-light"><?php echo $subKeyword['title']; ?></span>
                            <?php endforeach; ?>
                        </td>
                    </tr>
                    <?php endif; ?>
                <?php endforeach; ?>
            </tbody>
        </table>

        <!-- Modal -->
        <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header border-0">

                        <h1 class="modal-title fs-5" id="staticBackdropLabel">Grab a coffee, we are creating your article(s)..</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                    </div>
                    <div class="modal-body border-0 d-flex justify-content-center align-items-center h-100" style="height: 16rem;">

                            <div class="spinner-border text-primary" role="status">
                                <span class="sr-only"></span>
                            </div>

                    </div>
                    <div class="modal-footer d-flex justify-content-end border-0">

                        <?php if (!function_exists('yoast_get_meta_options')): ?>
                            <div class="alert alert-secondary border-0" role="alert">We recommend using Yoast SEO plugin for better results.</div>
                        <?php endif; ?>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                    </div>
                </div>
            </div>
        </div>
        
    </div>
    
    <?php
}
?>