<?php

function create_post() {
    $new_post = array(
        'post_title'    => 'My new content pilot article', // Title of the post
        'post_content'  => 'This is the content of my new post.', // Content of the post
        'post_status'   => 'publish', // Publish the post immediately
        'post_author'   => 1, // Assign the post to the admin user (ID 1)
        // Add other post data as needed (e.g., post_type, post_category, tags, etc.)
    );

    $post_id = wp_insert_post( $new_post );

    if ( is_wp_error( $post_id ) ) {
        // Handle errors
        $error_string = $post_id->get_error_message();
        echo '<div class="error"><p>' . $error_string . '</p></div>';
    } else {
        // Post created successfully
        echo '<div class="updated"><p>New post created with ID ' . $post_id . '</p></div>';
    }
}

function get_all_posts() {
    $args = array(
        'posts_per_page' => -1, // Get all posts (no limit)
        'post_type'      => 'post', // Default post type
        'post_status'    => 'publish', // Only published posts
    );

    $posts = get_posts( $args );

    if ( $posts ) {
        foreach ( $posts as $post ) {
            setup_postdata( $post ); // Important for template tags

            // Access post data
            the_title(); 
            the_content(); 

            // ... other post data you need
        }
        wp_reset_postdata(); // Cleanup after the loop
    } else {
        // No posts found
        echo 'No posts found.';
    }
	return $posts;
}

?>