let base_url = 'https://stage.api.creatorpilot.ai';
if( window.location.host.includes('local') ) {
    base_url = 'http://localhost:3000';  
}
const api_url = base_url + '/v1';

jQuery( document ).on( 'heartbeat-send', function ( event, data ) {
    console.log('heartbeat-send');
    // Add additional data to Heartbeat data.
    data.status = 'some_data';
});

jQuery( document ).on( 'heartbeat-tick', function ( event, data ) {
    console.log('heartbeat-tick');
    
    if( window.location.href.includes('creatorpilot-status') ) {

        // Check for our data, and use it.
        if ( ! data.status ) {
            console.log( 'The status is not defined'  );
        }
        else if ( data.status === 'ready' ) {
            console.log( 'The status is ' + data.status );
            // forward to the keywords page
            window.location.href = 'admin.php?page=creatorpilot-keywords';
        }
        else{
            console.log( 'attribute wasnt present in heartbeat' );
        }

    }
	
});

jQuery( document).ready(function($) {

    function collectCheckedInputs(publish = false) {
        
        var masterIds = [];
        var checkboxes = document.querySelectorAll('input[type="checkbox"]:checked');

        // check if there are any checkboxes
        if (checkboxes.length > 0) {
        
            // show the waiting modal
            const options = {
                keyboard: false
            }
            const myModal = new bootstrap.Modal('#staticBackdrop', options)
            myModal.show();

            // add click event listener to each checkbox
            checkboxes.forEach(checkbox => {
                // get the keyword id from the data-keyword-id attribute
                var keywordId = checkbox.getAttribute('data-keyword-id');
                // add the keyword id to the array
                masterIds.push(keywordId);
            });

            // post all the keyword ids as a array of string to the server and get the response id
            $.ajax({
                url: api_url + '/posts/generate-bulk',
                type: 'POST',
                data: {"ids": masterIds, "publish": publish},
                success: function(response) {
                    
                    // get the last job id from the response array
                    var lastJobId = response[response.length - 1];
                    var interval = setInterval(function() {
                        // check the response status if its completed, close the modal
                        $.ajax({
                            url: api_url + '/jobs/status/' + lastJobId + '/posts',
                            success: function(response) {
                                responseStatus = response;
                                // get the last number from a comma separated string
                                if (responseStatus === 'completed') {
                                    clearInterval(interval);
                                    // hide the modal
                                    myModal.hide();
                                    window.location.href = 'admin.php?page=creatorpilot-keywords&update=true';
                                }
                            }
                        });
                    }, 5000);
                }
            });

        }
        else{
            alert('no checkboxes found');
        } 
    }
    window.collectCheckedInputs = collectCheckedInputs;
    
    function selectAllKeywords(target) {
        var checkbox = target;
        if (checkbox.checked) {
            var checkboxes = document.querySelectorAll('input[type="checkbox"]:not(:checked)');
            checkboxes.forEach(checkbox => {
                console.log(checkbox);
                checkbox.checked = true;
            });
        }
        else{
            var checkboxes = document.querySelectorAll('input[type="checkbox"]:checked');
            checkboxes.forEach(checkbox => {
                checkbox.checked = false;
            });
        }
    }
    window.selectAllKeywords = selectAllKeywords;

    function generateArticle(keywordId, publish = false) {

        // show the waiting modal
        const options = {
            keyboard: false
        }
        const myModal = new bootstrap.Modal('#staticBackdrop', options)
        myModal.show();

        var responseId = '';
        var responseStatus = '';
        $.ajax({
            url: api_url + '/posts/generate/' + keywordId + '?publish=' + publish,
            type: 'POST',
            success: function(response) {
                
                responseId = response;
                var interval = setInterval(function() {
                    // check the response status if its completed, close the modal
                    $.ajax({
                        url: api_url + '/jobs/status/' + responseId + '/posts',
                        success: function(response) {
                            responseStatus = response;
                            if (responseStatus === 'completed') {
                                clearInterval(interval);
                                // hide the modal
                                myModal.hide();
                                window.location.href = 'admin.php?page=creatorpilot-keywords&update=true';
                            }
                    
                        }
                    });
                }, 5000);
            },
            error: function(error) {
                console.log('error: ' + JSON.stringify(error));
            }
        });

    }

    // Make the function globally available
    window.generateArticle = generateArticle;

    // Or add a click event listener to a button
    $('.generate-article-btn').on('click', function() {
        const keywordId = $(this).data('keyword-id');
        generateArticle(keywordId);
    });

    // if the element with id status-page is found
    if( jQuery( '#status-page' ).length > 0 ){
        
        // increase the progress bar with id progress-bar with 20% each minute until it reaches 100%
        // set one minute in milliseconds
        var oneMinute = 10000;
        // get the width of the progress bar as a integer
        var progressWidth = parseInt( jQuery( '.progress' ).css( 'width' ) );
        
        // divide the width by 5
        var widthIncrement = progressWidth / 6;
        
        const interval = setInterval(() => {
            var progressBar = jQuery( '#progress-bar' );
            // get the width of the progress bar as an integer
            var width = parseInt( progressBar.css( 'width' ) );

            // increase the width by 20%
            width = width + widthIncrement;

            progressBar.css( 'width', width + 'px' );
            // get the width of the progress bar as a percentage
            var widthPercentage = (width / progressWidth) * 100;

            progressBar.html( Math.trunc(widthPercentage) + '%' );
            // if width is 100%, stop the interval
            // time is up
            if (widthPercentage >= 100) {
                clearInterval(interval);
                // forward to the keywords page
                window.location.href = 'admin.php?page=creatorpilot-keywords';
            }

        }, oneMinute);

    }
  
    // Fetch all the forms we want to apply custom Bootstrap validation styles to
    const forms = document.querySelectorAll('.needs-validation')
  
    // Loop over them and prevent submission
    Array.from(forms).forEach(form => {
      form.addEventListener('submit', event => {
        if (!form.checkValidity()) {
          event.preventDefault()
          event.stopPropagation()
        }
  
        form.classList.add('was-validated')
      }, false)
    })


    // generic form submission handling
    $('.action-form').submit(function(event) {
        // prevent default form submission
        event.preventDefault();
        event.stopPropagation();

        // get the form method
        var method = $(this).attr('method');

        // get the form input with name 'action'
        var action = $(this).find('input[name="action"]').val();

        // convert to json object from the form data
        var data = {};
        $(this).serializeArray().forEach(function(item) {
            data[item.name] = item.value;
        });

        let debug = false;
        
        if (!debug) {
            $.ajax({
            url: my_ajax_obj.ajax_url,
            type: method,
            data: data,
            success: function(response) {
                if (response.success) {

                    // read the status code from the response
                    var statusCode = response.data.response.statusCode;
                    console.log('statusCode: ' + statusCode);
                    if (!statusCode || statusCode == 200) {
                        window.location.href = response.data.redirect;
                    }
                    else if (statusCode == 400) {
                        // validation error
                        console.log('audience: ' + response.data.audience);
                        console.log('400 validation error: ' + JSON.stringify(response.data.response.message));
                    }
                    else if (statusCode == 401) {
                        console.log('401 error: ' + JSON.stringify(response.data.response.message));
                    }
                    else if (statusCode == 403) {
                        console.log('403 error: ' + JSON.stringify(response.data.response.message));
                    }
                    else if (statusCode == 404) {
                        console.log('404 error: ' + JSON.stringify(response.data.response.message));
                    }
                } else {
                    console.log('error: ' + JSON.stringify(response));
                }
            },
            error: function(error) {
                console.log('error: ' + JSON.stringify(error));
                console.log('method: ' + method);
                console.log('action: ' + action);
                console.log('URL: ' + my_ajax_obj.ajax_url);
                console.log('formData: ' + JSON.stringify(formData));
                }
            });
        }

    });
    

});